#!/bin/bash
# Demonstration: Transform various sources into Bogostian word pools

echo "=== Bogostian Ontographer Demonstration ==="
echo ""

# Example 1: From a text file
echo "1. Processing a literary text..."
cat << 'EOF' > /tmp/sample_literary.txt
In the quantum cathedral of memory, where electrons dance with consciousness,
the philosopher's stone transmutes silicon into wisdom. Beneath the digital 
firmament, algorithms dream of electric sheep while neurons fire in patterns
that mirror the architecture of galaxies. The ancient lighthouse stands witness
to this marriage of carbon and silicon, organic and synthetic, as dragonflies
hover over pools of liquid crystal displaying the dreams of machines.
EOF

python3 scripts/text_to_js.py /tmp/sample_literary.txt -o literary_words.js
echo ""

# Example 2: From a URL (using a placeholder)
echo "2. Processing web content..."
echo "curl -s 'https://example.com/article' | python3 scripts/text_to_js.py - -o web_words.js"
echo "(This would fetch and process live web content)"
echo ""

# Example 3: Combining multiple sources
echo "3. Creating a combined word pool..."
cat << 'EOF' > /tmp/sample_technical.txt
The oscilloscope reveals waveforms in the electromagnetic spectrum while
capacitors store potential energy. Transistors switch states, binary logic
gates process information, and servo motors respond to control signals.
In the laboratory, scientists observe quantum entanglement through 
sophisticated interferometers measuring photon polarization states.
EOF

# Process both files
python3 scripts/bogostian_clean.py /tmp/sample_literary.txt --output-format list > /tmp/words1.txt
python3 scripts/bogostian_clean.py /tmp/sample_technical.txt --output-format list > /tmp/words2.txt

# Combine and deduplicate
cat /tmp/words1.txt /tmp/words2.txt | sort -u > /tmp/combined.txt

# Generate final JS
python3 scripts/generate_js.py /tmp/combined.txt -o combined_words.js --sort

echo ""
echo "=== Generated Files ==="
echo "- literary_words.js (from literary text)"
echo "- combined_words.js (from multiple sources)"
echo ""
echo "Each file is formatted as:"
echo 'const wordPool = ['
echo '    "word1",'
echo '    "word2",'
echo '    ...'
echo '];'
