# The Bogostian Ontographical Word Cleaning Paradigm - Complete Reference

## Core Philosophy

The goal is NOT to create a clean, organized taxonomy.
The goal IS to reveal "the repleteness of units and their interobjectivity" - to catalog things that can act as "mutual aliens" in a list, creating the "jarring staccato of real being" rather than smooth narrative flow.

## The Bogostian Decision Tree

For each candidate word, ask in order:

1. **Is it a real word or legitimate proper noun?**
   - NO → DELETE

2. **Is it a connecting word (article, preposition, pronoun)?**
   - YES → DELETE

3. **Is it a number or code?**
   - YES → DELETE (unless culturally loaded like "Area 51")

4. **Is it interface cruft or web navigation?**
   - YES → DELETE

5. **Is it a pure abstraction without material anchor?**
   - YES → DELETE

6. **Is it redundant with other forms of same root?**
   - YES → CHOOSE ONE

7. **Is it a verb form when noun form exists?**
   - PREFER NOUN

8. **Does it name a UNIT that can exist in flat ontology?**
   - NO → DELETE

9. **Does it create ontological friction/surprise?**
   - NO → CONSIDER DELETE

10. **Would Bogost include it in a litany?**
    - If you hesitate → DELETE

## Quality Criteria

### Heterogeneity Check
- Do you have objects at wildly different scales?
- Do you mix natural and cultural objects?
- Do you have both concrete and (some) abstract units?
- Would these words surprise when placed next to each other?

### Flatness Check
- Can each word stand alone as a unit?
- Does the list avoid hierarchical relationships?
- Would no word seem "more important" than another?

### Disjunction Check
- Do the words resist flowing into a narrative?
- Do they create "jarring staccato" when read in sequence?
- Are they "mutual aliens" to each other?

### Density Check
- Does each word point to a rich, withdrawn interior?
- Could you imagine each as "a set of other units acting together"?
- Do the words invite speculation about their relations?

## Special Cases

### KEEP These Types of Words

**Concrete Objects**: hammer, tree, lighthouse, dragonfly, truck, whistle, gun

**Places & Spaces**: Herefordshire, Rio de Janeiro, basement, pillory, altar

**Living Beings**: bee, piranha, bear, rat, worker, child, professor

**Materials**: carbon, oxygen, steel, bronze, concrete, acrylic, vinyl

**Bounded Concepts**: marriage, dream, tornado, miracle, election, ceremony

**Cultural Artifacts**: book, movie, letter, painting, sculpture, photograph

**Evocative Abstractions** (sparingly): unconscious, mystery, bet, nothing, elegance, momentum, decay

### DELETE These Types of Words

**Connecting Words**: a, an, the, in, on, at, by, with, from, of, and, or, but, he, she, it, they

**Web Cruft**: home, about, contact, login, submit, click, here, read, more, error, loading

**Pure Abstractions**: accessibility, functionality, implementation, management, processing

**Verb Forms**: running, eating, processing (unless they name things like "building", "painting")

**Interface Labels**: username, password, email, navigation, header, footer

## Edge Cases

- **Brand Names**: Keep if culturally iconic (Coca-Cola), delete if generic (Acme Corp)
- **Technical Terms**: Keep if they name objects (transistor), delete if abstract (API)
- **Places**: Keep real places (Tokyo), delete interface locations (homepage)
- **Names**: Keep evocative names (Ophelia), delete generic ones (John)
- **Neologisms**: Keep if in cultural vocabulary (cyborg, internet)
- **Archaic Words**: Keep for their strangeness (ye, wherefore, methinks)
- **Scientific Terms**: Keep if they name units (quark, neuron), not processes
- **Tools**: Keep specific tools (claw hammer), delete general ones (equipment)

## Size Guidelines

- **Minimum**: 30-50 words (for basic variety)
- **Optimal**: 100-500 words (rich possibility space)
- **Maximum**: 1000-2000 words (before repetition fatigue)

## Output Format

The cleaned word list should be presentable as:
- A JavaScript array for use in Bogostian litany generators
- A flat list for philosophical contemplation
- A categorized breakdown for analysis

Remember: The litany should create what Bogost calls "the jarring staccato of real being" - not smooth taxonomy, but surprising juxtaposition.
